import 'package:dartz/dartz.dart';
import 'package:razinsoft_rider/data/models/chat_message_response/chat_message_response.dart';
import 'package:razinsoft_rider/data/models/common_response.dart';
import '../../../core/errors/failure.dart';

abstract class IChatRepo {
  Future<Either<Failure, ChatResponse>> getMessage(
      {required int userId});
  Future<Either<Failure, CommonResponse>> sendMessage(
      {required int receiverId, required String message});
}
